Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[hatchery.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[mission5.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 0.0,
		StartBPMultiplier 	= 2.0,
		
		DefaultHiveTowerCount = 5,
		--CaptureRateK = 2.0,
		
	},
	Rules = 
	{
		AutoCapture 	= false,		--Destroying hives automatically counts as a capture
		NoPushback		= false,		--Can the player's points be captured?
		NoTowerRespawn  = false,        --Can the hive towers respawn?
		WeakenHiveOnCap = false,        --Do captures halve defensive strength?
		DisableLockdown = true,        	--Turn off emergency help is player is behind
		NoAdvance       = false,       	--Do not allow player to capture points
		HiveCtrAttack   = false,        --Send alien spawn to undefended alien hives
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 0,
		Default = [[disabled]],
		Active =
		{
			[[ZU_SANDKING_GUARDIANS]],
		},
		Queue =
		{
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[inactive]],
		--FreeUpgradesDefault = [[active]],
		Active =
		{
			[[MU_BUNKERS]],
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	GetLevelProgress = function ()
        
        local progress = 0

        if survivalTimer then
            progress = (survivalDuration - survivalTimer:GetTimerLeft()) / survivalDuration
        end
        
		return progress --math.pow(progress, 1.5)
		
	end,
		
	OnDebugCall = function (mousePos)

        local entities = {}
        GameWorld:AreaQuery(mousePos, 3.0, entities)
        
        for i=1, #entities do
            if entities[i]:GetId() == "RewardBPCrate" then
                return
            end
        end
        
        GameWorld:CreateEntity("BPCrate", "RewardBPCrate", mousePos)

	end
}


survivalDuration = 13*60000
survivalTimer = nil

------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		
--[[
		local general = GameWorld:GetEntityById("general")
        if general then
			GameWorld:RegisterRaidTarget(general)
		end
--]]		
		LevelUtils.ShowTimedDialogue("You are late Drake - I am about to finish off this disgusting, stinking creature.\n\nI should have done this in person a long time ago.", "General")

        LossCondition:Enable()
        KillBossObjective:Enable()

        TeamDropScript:Enable()

		self:Disable()
	end)
LevelInit:Enable()

function ChopperMission(p_destId)

    local dropArea = GameWorld:GetEntityById(p_destId);
    if dropArea then
        local chopper = GameWorld:SpawnChopper(vect2f(0.5, 1.0), dropArea:GetPos())
        chopper:SetMission(ChopperOrder.CO_HOVER, dropArea:GetPos(), "")
    end 

end

------------------------------------------------------------------------------- Chopper Team Drop
TeamDropScript = LevelUtils.MakeGoal(
	function (self)	
		local landingArea = GameWorld:GetEntityById("startPoint")
		if landingArea then
			local chopper = GameWorld:SpawnChopper(vect2f(-0.3, 1.0), landingArea:GetPos())
			chopper:SetMission(ChopperOrder.CO_DELIVERY, landingArea:GetPos(), "Marines")
		end
	end,
	
	{[[NT_CHOPPER_DELIVERY]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		if p_other ~= "Marines" then
			return
		end
		
		GameWorld:AddMarines(p_pos, GameWorld:GetStartingTeamSize())
	
	    LevelUtils.ShowTimedDialogue("You arrogant fool - get your ass behind a desk where it belongs.", "Sarge")
	
		self:Disable()
	end)

------------------------------------------------------------------------------- Kill the Boss hive objective
KillBossObjective = LevelUtils.MakeGoal(
	function (self)

        local boss = GameWorld:GetEntityById("bossHive")
		boss:SetDamageResistance(0.3) 
		
	    GameWorld:AddObjective("bossObj", "Destroy the giant hive")

    end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
        if p_entId ~= "bossHive" then
            return
        end

        GameWorld:ChangeObjectiveStatus("bossObj", [[complete]])
        
		LevelUtils.ShowTimedDialogue("YES!\n\nDead for the last time, I hope.  This is how it should be done, Drake.", "General")
		
        StartHiveRespawning()

        ScriptMgr:DoDelayedCall(5500,
            function()
                
                OrderMarineAssault("general", {"hiveArea1", "hiveArea3", "hiveArea2", "hiveArea4", "hiveArea5"})
                OrderMarineAssault("marine3", {"hiveArea1", "hiveArea3", "hiveArea2", "hiveArea4", "hiveArea5"})
                OrderMarineAssault("marine4", {"hiveArea1", "hiveArea3", "hiveArea2", "hiveArea4", "hiveArea5"})
                
                OrderMarineAssault("marine1", {"hiveArea3", "hiveArea2", "hiveArea4", "hiveArea5"})
                OrderMarineAssault("marine2", {"hiveArea3", "hiveArea2", "hiveArea4", "hiveArea5"})
                
                OrderMarineAssault("marine5", {"hiveArea4", "hiveArea5"})
                
                CreateWinTimer()
                
                ScriptMgr:DoDelayedCall(survivalDuration - 10000,
                    function()
                        
                        ChopperMission("evacPoint1")
                        ChopperMission("evacPoint2")
                        ChopperMission("evacPoint3")
                        
                        ScriptMgr:DoDelayedCall(7000,
                                                function()
                                                    LevelUtils.ShowTimedDialogue("The birds are here, squad!\n\nHop on - let's get the hell out of here.", "Sarge")
                                                end)
                    end)
                
                ScriptMgr:DoDelayedCall(survivalDuration - 2*60000,
                    function()
                        
                        GameWorld:ActivateMutation("ZU_TOWER_CARAPACE", false)
                        GameWorld:ActivateMutation("ZU_HIVE_SPIKES", false)
                        GameWorld:ActivateMutation("ZU_DEF_SPITTERS", false)
                        
                        LevelUtils.ShowTimedDialogue("The evac is almost there, commander.  Just a little bit longer.", "Scout")
                        
                    end) 
                
            end)	

        ScriptMgr:DoDelayedCall(5000,
            function()
                
                GameWorld:ActivateMutation("ZU_SPAWN_SPITTERS", false)
                GameWorld:ActivateMutation("ZU_WALK_SPEED", false)
                                
                LevelUtils.ShowTimedDialogue("Watch out! AMBUSH!", "Scout")

                ActivateAttackWave(3)
                
            end)
          
		
	end,
	
	function (self)
	end)


hiveEntities = {}

function SpawnHive(index)

    local entId = "hiveArea" .. index
    local marker = GameWorld:GetEntityById(entId)
    
    if marker and (hiveEntities[index] == nil or hiveEntities[index]:GetPtr() == nil) then
        local hive = GameWorld:SpawnHive(marker:GetPos())
        
        hiveEntities[index] = hive:GetHandle()
    end

end

function SpawnHivesCascade(p_baseDelay, p_indexList)
    
    for i=1, #p_indexList do
    
        local index = p_indexList[i]
        ScriptMgr:DoDelayedCall(p_baseDelay + i*300,
            function()
                SpawnHive(index)
            end)	    

    end
    
end

function OrderMarineAssault(p_marineId, p_waypointIdArray)

    local marine = GameWorld:GetEntityById(p_marineId)
    if not marine then
        return
    end
    
    local human = marine:ToCHuman()
    if not human then
        return
    end    
    
    for i=1, #p_waypointIdArray do
        local waypointId = p_waypointIdArray[i]
        local waypoint = GameWorld:GetEntityById(waypointId)
        
        if waypoint then
            human:SendCommand(ICommandable.CT_ATTACKMOVE, waypoint:GetPos(), nil, true)
        end
        
    end

end

-- AGGRESSION Scripts ----------------------------------------------------------------------------------------------

local aggressionTimer = 0 
local aggressionCapturesNeeded = 0
function ActivateAttackWave(p_numCaptures)
    aggressionTimer = 60000
    aggressionCapturesNeeded = p_numCaptures
    GameWorld:RelayEvent([[NT_ALIEN_BESERK_SIGNAL]], "", vect2f(), "")
end

function DeactivateAttackWave()
    aggressionTimer = 0
end

function GetAreAliensAggressive()
    return aggressionTimer > 0 or GetAreAliensSuperAggressive()  
end

function GetAreAliensSuperAggressive()
    return CaptureAndLossTracker.current_score >= -GameWorld:GetStat([[ST_GAMETIME]]) / 90000 or CaptureAndLossTracker.current_score <= -9
end

function GetAreAliensTame()
    return CaptureAndLossTracker.current_score < -3-GameWorld:GetStat([[ST_GAMETIME]]) / 90000
end

local generalDead = false;
local rustActivated = false
local tameModeActivated = true 
ScriptMgr:DoDelayedCall(1000,
    function()
    
        if not generalDead and not GameWorld:GetEntityById("general") then
            LevelUtils.ShowTimedDialogue("Oh God\n\nThe General is dead.  They've got him.", "Scout") 
            generalDead = true
        end
    
        if GetAreAliensAggressive() then
            if GetAreAliensTame() then
                GameWorld:SetSpawnRate(10.0)
            elseif GetAreAliensSuperAggressive() then
                GameWorld:SetSpawnRate(40.0)    
            else
                GameWorld:SetSpawnRate(30.0)
            end
        else
            GameWorld:SetSpawnRate(0.0)       		    
        end
        
        GameWorld:SetSpawnRateScalingOn(false)
        
        --Super-aggressive mutations
        if GetAreAliensSuperAggressive() and not rustActivated then
            GameWorld:ActivateMutation("ZU_RUST", false)
            rustActivated = true
        end
        
        if not GetAreAliensSuperAggressive() and rustActivated then
            GameWorld:DeactivateMutation("ZU_RUST", false)
            rustActivated = false
        end       
 
        --Tame mutations
        if GetAreAliensTame() and not tameModeActivated then
			GameWorld:DeactivateMutation("ZU_HARDPOINT_GUARDS", false)
			GameWorld:DeactivateMutation("ZU_NECRONODE", false)
			GameWorld:DeactivateMutation("ZU_SPAWNER_SPECIAL", false)
			tameModeActivated = true
        end
        
        if not GetAreAliensTame() and tameModeActivated then
			GameWorld:ActivateMutation("ZU_HARDPOINT_GUARDS", false)
			GameWorld:ActivateMutation("ZU_NECRONODE", false)
			GameWorld:ActivateMutation("ZU_SPAWNER_SPECIAL", false)
			tameModeActivated = false
        end        
        
        return true
    end)


ScriptMgr:DoDelayedCall(30000,
    function ()
        if GetAreAliensSuperAggressive() then  --GetAreAliensAggressive() then
            GameWorld:RelayEvent("NT_ALIEN_BESERK_SIGNAL", "", vect2f(), "")
        end
        
        return true
    end)


function MakeIndexList(p_maxIndex)

    local indexTable = {}
    for i=1, p_maxIndex do
        table.insert(indexTable, i)
    end
    
    return indexTable

end

function StartHiveRespawning()
    local waveHiveNumber = 5
    
    SpawnHivesCascade(5000, MakeIndexList(waveHiveNumber))
    ScriptMgr:DoDelayedCall(150000,
        function()
            SpawnHivesCascade(1, MakeIndexList(waveHiveNumber))
            waveHiveNumber = waveHiveNumber + 1
            
            return true
        end)
end

function AggroTimerUpdate(p_milliseconds)
    local wasAggressive = GetAreAliensAggressive()

    aggressionTimer = aggressionTimer - p_milliseconds
    
    if aggressionCapturesNeeded <= 0 or aggressionTimer < 0 then
        aggressionTimer = 0
    end
    
    if wasAggressive and not GetAreAliensAggressive() then
        ScriptMgr:DoDelayedCall(90000,
            function()
                ActivateAttackWave(2)
            end)        
    end
    
    GameWorld:SetRule("NoTowerRespawn", aggressionTimer <= 0)
	
	if CaptureAndLossTracker.current_score <= -9 then
		GameWorld:SetParam("CaptureRateK", 10.0)
    else
		GameWorld:SetParam("CaptureRateK", 1.0)
	end
	
    --GameWorld:SetEventIndicator(string.format("%d:%02d", aggressionTimer / 60000, (aggressionTimer % 60000) / 1000))
end
ScriptMgr:SetUpdateCallback(AggroTimerUpdate)


	
------------------------------------------------------------------------------- Hive Destroyed BP Crate spawn			
			
HiveCrateScript = LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
        if p_other ~= "DNT_HIVE" then
            return
        end
        
        local entities = {}
        GameWorld:AreaQuery(p_pos, 3.0, entities)
        
        for i=1, #entities do
            if entities[i]:GetId() == "RewardBPCrate" then
                return
            end
        end
        
        GameWorld:CreateEntity("BPCrate", "RewardBPCrate", p_pos)
	end)
HiveCrateScript:Enable()

	
------------------------------------------------------------------------------- Protohive (necronode) spawn type override
ProtohiveScript = LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_ALIEN_STRUCTURE_SPAWNED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
        if p_other ~= "CNecronode" then
            return
        end
        
        local ent = GameWorld:GetEntityById(p_entId)
        if ent then
            local necNode = ent:ToCNecronode()
            
            if necNode then
                necNode:SetSpawnType(PHSpawnType.ST_SPITTER)
            end
        end
	end)
ProtohiveScript:Enable()

------------------------------------------------------------------------------- Spawned buildings timeout script
AlienBuildingDeprecationScript = LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_ALIEN_STRUCTURE_SPAWNED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
        local ent = GameWorld:GetEntityById(p_entId)
        
        if ent then
            local hdl = ent:GetHandle()
            
            ScriptMgr:DoDelayedCall(90000,
                function()
                    local ent2 = hdl:GetPtr()
                    
                    if ent2 then
                        ent2:Kill()
                    end
                end)           
        end

	end)
AlienBuildingDeprecationScript:Enable()

cratesDeployed = {}

------------------------------------------------------------------------------- Capture and Loss Tracker
CaptureAndLossTracker = LevelUtils.MakeGoal(
	function (self)
		self.current_score = 0
		self.min_score = 0
	end,
	
	{[[NT_POINT_CAPTURED]], [[NT_POINT_LOST]]},
	function (self, p_type, p_entId, p_pos, p_other)	
        if p_type == [[NT_POINT_CAPTURED]] then
            self.current_score = self.current_score + 1
        end
        
        if p_type == [[NT_POINT_LOST]] then
            self.current_score = self.current_score - 1
            aggressionCapturesNeeded = aggressionCapturesNeeded - 1
        end
        
        for i=0, -self.current_score do
            if not cratesDeployed[i] then
            
                local crateArea = GameWorld:GetEntityById("crateDropArea" .. i);
                if crateArea then
                    local chopper = GameWorld:SpawnChopper(vect2f(0.0, 1.0), crateArea:GetPos())
                    chopper:SetMission(ChopperOrder.CO_DELIVERY, crateArea:GetPos(), "BPCrates")
                end                
            
                cratesDeployed[i] = true
            end
        end
        
        if self.current_score < self.min_score then
            self.min_score = self.current_score
            
            if self.min_score == -3 then
                LevelUtils.ShowTimedDialogue("Hang in there, Drake.\n\nI'm sending an evac chopper.  Just hold out for a few minutes.", "Scout")
            elseif self.min_score == -6 then
                LevelUtils.ShowTimedDialogue("This one's going to be awful close squad.\n\nIf we get out of this, I'm buyin everyone a round.", "Sarge")
            elseif self.min_score == -9 then
                LevelUtils.ShowTimedDialogue("This aint lookin good.\n\nShould have never come to this forsaken hellhole.", "Sarge")
            end
        end
                
	end)

CaptureAndLossTracker:Enable()

------------------------------------------------------------------------------- Chopper Delivery (BP)
CrateDrop = LevelUtils.MakeGoal(
	function (self)		
	end,
	
	{[[NT_CHOPPER_DELIVERY]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		if p_other ~= "BPCrates" then
			return
		end
		
		local crate1 = GameWorld:CreateEntity("BPCrate", "", p_pos + vect2f(3.5,0))
		local crate2 = GameWorld:CreateEntity("BPCrate", "", p_pos + vect2f(-3.5,0))
		--local crate3 = GameWorld:CreateEntity("BPCrate", "", p_pos + vect2f(-3.5,-3.5))
		
		--self:Disable()
	end)
CrateDrop:Enable()

------------------------------------------------------------------------------- Lost all points
LossCondition = LevelUtils.MakeGoal(
	function (self)	
	end,
	
	{[[NT_ALL_POINTS_LOST]]},
	function (self, p_type, p_entId, p_pos, p_other)
		--GameWorld:ChangeObjectiveStatus("winObj", [[failed]])
	
		GameWorld:ClearText()
		GameWorld:GameOver(false)
	
		CaptureAllGoal:Disable()
	
		self:Disable()
	end)
LossCondition:Enable()

------------------------------------------------------------------------------- Win Timer

function CreateWinTimer()

    GameWorld:AddObjective("surviveObj", "Survive until rescued")

    survivalTimer = LevelUtils.CreateTimer( survivalDuration,
                                            "SURVIVE FOR %s",
                                            function()
                                                GameWorld:ChangeObjectiveStatus("surviveObj", [[complete]])
                                            
                                                GameWorld:ClearText()
                                                GameWorld:GameOver(true)
                                                
                                                if CaptureAndLossTracker.current_score > -9 then
                                                    SteamAchievements:SetAchievement("BEAT_MEMENTO_MORI_EXTRA_HOLDOUT")
                                                end
                                            end)
                        
end